package gui;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import java.awt.BorderLayout;
//import javax.swing.JScrollPane;
//import java.awt.Dimension;

/**
 * @author Andrea
 *
 */
public class GraphViewerPanel extends JPanel
{
	static final long serialVersionUID = 1L;
	private JLabel graphNameLabel = null;
	private JPanel graphPanel = null; 
	/**
	 * This method initializes 
	 * 
	 */
	public GraphViewerPanel() {
		super();
		initialize();
	}
	/**
	 * This method initializes this class
	 * 
	 */
	private void initialize() {
        this.setLayout(new BorderLayout());
        this.add(getGraphNameLabel(), BorderLayout.NORTH);
        //this.add(getGraphScroller(), BorderLayout.CENTER);
			
	}
	/**
	 * This method initializes graphNameLabel	
	 * 	
	 * @return javax.swing.JLabel	
	 */
	private JLabel getGraphNameLabel() {
		if (graphNameLabel == null) {
			graphNameLabel = new JLabel();
			graphNameLabel.setText("");
			graphNameLabel.setHorizontalTextPosition(SwingConstants.CENTER);
			graphNameLabel.setHorizontalAlignment(SwingConstants.CENTER);
		}
		return graphNameLabel;
	}
	/**
	 * This method initializes graphScroller	
	 * 	
	 * @return javax.swing.JScrollPane	
	 */
	/*
	private JScrollPane getGraphScroller() {
		if (graphScroller == null) {
			graphScroller = new JScrollPane(null);
			graphScroller.setSize(new Dimension(92, 40));
			graphScroller.setViewportView(new JPanel());

		}
		return graphScroller;
	}
	*/
	
	public void printGraph(JPanel vv)
	{
		if(graphPanel!=null)
			this.remove(graphPanel);
		graphPanel = vv;
		this.add(graphPanel,BorderLayout.CENTER);
		updateUI();
		this.graphPanel.updateUI();
	}
	
	public void setGraphName(String name)
	{
		graphNameLabel.setText(name);
	}
	
	public void resetGraphPanel(){
		if (graphPanel != null) {
			//graphScroller.setViewportView(new JLabel());
			graphPanel = new JPanel(new BorderLayout());
			updateUI();
		}
		graphNameLabel.setText("");
	}
	
}
